/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: netX50_gpio_irq.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    netX50 GPIO Interrupt loss workaround

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-04-15  File created.

**************************************************************************************/


#ifndef __NETX50_TIMER_IRQ__H
#define __NETX50_TIMER_IRQ__H

typedef void(*PFN_GPIO_PRECLEAR_NOTIFICATION)(void* pvUser);
typedef void(*PFN_GPIO_POSTCLEAR_NOTIFICATION)(void* pvUser);

/* Callbacks that can be registered in global variables to insert a hook
   into the GPIO confirmation code. Chaining is not possible so only callback 
   can be registered */
extern PFN_GPIO_PRECLEAR_NOTIFICATION g_pfnConfirmGpioPreClear;
extern void*                          g_pvConfirmGpioPreClearUser;
extern PFN_GPIO_PRECLEAR_NOTIFICATION g_pfnConfirmGpioPostClear;
extern void*                          g_pvConfirmGpioPostClearUser;

/* GPIO confirmation function */
void netX50ConfirmGpioIrq(unsigned long ulConfirm, unsigned long ulMask);

#endif /* __NETX50_TIMER_IRQ__H */
